package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppAlternativeStore

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
enum class AltAppStore(val storeName: String) {
    HUAWEI_APP_GALLERY("AppGallery"),
    XIAOMI_GET_APPS("GetApps"),
    SAMSUNG_GALAXY_STORE("GalaxyStore"),
    VIVO_APP_STORE("VivoStore"),
    ;

    companion object {
        fun fromId(storeName: String): AltAppStore {
            return values().first { it.storeName == storeName }
        }

        fun AltAppStore.toCoreType(): MobileAppAlternativeStore =
            when (this) {
                HUAWEI_APP_GALLERY -> MobileAppAlternativeStore.HUAWEI_APP_GALLERY
                XIAOMI_GET_APPS -> MobileAppAlternativeStore.XIAOMI_GET_APPS
                SAMSUNG_GALAXY_STORE -> MobileAppAlternativeStore.SAMSUNG_GALAXY_STORE
                VIVO_APP_STORE -> MobileAppAlternativeStore.VIVO_APP_STORE
            }

        fun MobileAppAlternativeStore.fromCoreType(): AltAppStore =
            when (this) {
                MobileAppAlternativeStore.HUAWEI_APP_GALLERY -> HUAWEI_APP_GALLERY
                MobileAppAlternativeStore.XIAOMI_GET_APPS -> XIAOMI_GET_APPS
                MobileAppAlternativeStore.SAMSUNG_GALAXY_STORE -> SAMSUNG_GALAXY_STORE
                MobileAppAlternativeStore.VIVO_APP_STORE -> VIVO_APP_STORE
            }
    }
}
