package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class AppInfo(
    val id: String?,
    val appId: String,
    val bundleId: String?,
    val title: String?,
    val subtitle: String?,
    val description: String?,
    val iconUrl: String?,
    val language: String?,
    val platform: Platform,
    val region: String?,
    val vendor: String?,
    val rating: Double?,
    val reviews: Int?,
    val ageLimit: Int?,
    val minOsVersion: String?,
    val url: String,
    val currency: String?,
    val price: Double?,
    val interests: Set<Int>?,
    val recommendedCpa: Long?,
    val recommendedCpi: Long?,
)
