package ru.yandex.direct.core.entity.uac.model

data class MdsInfo(
    val thumb: String,
    val sourceUrl: String,
    val mdsUrl: String?,
    val filename: String?,
    val meta: Map<String, Any?>,
)

interface Asset {
    val id: String
    val clientId: String
}

interface MediaAsset : Asset {
    val mdsInfo: MdsInfo
}

data class TextAsset(
    override val id: String,
    override val clientId: String,
    val text: String,
) : Asset

data class TitleAsset(
    override val id: String,
    override val clientId: String,
    val title: String,
) : Asset

data class VideoAsset(
    override val id: String,
    override val clientId: String,
    override val mdsInfo: MdsInfo,
    val videoDuration: Int,
) : MediaAsset

data class ImageAsset(
    override val id: String,
    override val clientId: String,
    override val mdsInfo: MdsInfo,
    val directImageHash: String,
) : MediaAsset

data class SitelinkAsset(
    override val id: String,
    override val clientId: String,
    val title: String,
    val href: String,
    val description: String?,
) : Asset

data class Html5Asset(
    override val id: String,
    override val clientId: String,
    override val mdsInfo: MdsInfo,
): MediaAsset

data class LinkedAsset<T : Asset>(
    val order: Int,
    val isRemoved: Boolean,
    val asset: T,
)

data class AssetContainer(
    val texts: List<LinkedAsset<TextAsset>> = emptyList(),
    val titles: List<LinkedAsset<TitleAsset>> = emptyList(),
    val sitelinks: List<LinkedAsset<SitelinkAsset>> = emptyList(),
    val images: List<LinkedAsset<ImageAsset>> = emptyList(),
    val videos: List<LinkedAsset<VideoAsset>> = emptyList(),
    val html5s: List<LinkedAsset<Html5Asset>> = emptyList(),
) {
    val mediaAssets = images + videos + html5s
}
