package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class CampaignContentStatus(val id: Int) {
    CREATED(1),
    REJECTED(2),
    MODERATING(3),
    ACTIVE(4),
    DELETED(5),
    ;

    companion object {
        fun fromId(id: Int): CampaignContentStatus {
            return values().first { it.id == id }
        }
    }

    @JsonValue
    open fun getCampaignContentStatus() = name.lowercase()
}
