package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class ContentStatisticsSortBy(@JsonValue val id: String) {
    EFFICIENCY("efficiency"),
    CONTENT_ID("content_id"),
    SHOWS("shows"),
    CLICKS("clicks"),
    CTR("ctr"),
    CONVERSIONS("conversions"),
    CR("cr"),
    CPA("cpa"),
    ID("id")
    ;

    companion object {
        fun fromId(id: String?): ContentStatisticsSortBy? =
            when (id) {
                EFFICIENCY.id -> EFFICIENCY
                CONTENT_ID.id -> CONTENT_ID
                SHOWS.id -> SHOWS
                CLICKS.id -> CLICKS
                CTR.id -> CTR
                CONVERSIONS.id -> CONVERSIONS
                CR.id -> CR
                CPA.id -> CPA
                ID.id -> ID
                else -> null
            }
    }
}
