package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class CreativeType(val id: String) {
    RMP("rmp"),
    TGO("tgo"),
    CPM("cpm"),
    HTML5("html5"),
    NON_SKIPPABLE_CPM("non_skippable_cpm")
    ;

    companion object {
        fun fromId(id: String): CreativeType {
            return CreativeType.values().first { it.id == id }
        }
    }

    @JsonValue
    open fun getType() = name.lowercase()
}
