package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.bidmodifier.GenderType

enum class Gender(val goalId: Long) {
    MALE(2499000001),
    FEMALE(2499000002)
    ;

    fun getGenderType(): GenderType {
        return when (this) {
            MALE -> GenderType.MALE
            FEMALE -> GenderType.FEMALE
        }
    }

    @JsonValue
    open fun getGender() = name.toLowerCase()
}
