package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GooglePlayAppInfoData(
    val adult: String?,
    val author: AppInfoAuthor?,
    val name: String?,
    val htmlDescription: String?,
    val icon: String?,
    val rating: AppInfoRating?,
    val price: AppInfoPrice?,
    val description: String?,
    val screens: List<String>?,
    val screensEx: List<AppInfoScreenEx>?,
    val categories: List<String>?,
    val videosS3: Map<String, String>?,
    val subcategoryEng: List<String>?,
)

data class AppInfoAuthor(
    val email: String?,
    val id: String?,
    val name: String?,
)

data class AppInfoRating(
    val value: Double?,
    val votes: Int?,
)

data class AppInfoPrice(
    val currency: String?,
    val value: Double?,
)

data class AppInfoScreenEx(
    val meta: AppInfoScreenMeta?,
)

data class AppInfoScreenMeta(
    @JsonProperty("orig-size")
    val origSize: AppInfoSize?,
    @JsonProperty("orig-orientation")
    val origOrientation: Int?,
)

data class AppInfoSize(
    val x: Int,
    val y: Int,
)
