package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class GroupByDateType(val date: String) {
    DAY("daily"),
    WEEK("weekly"),
    MONTH("monthly"),
    NONE("none")
    ;

    companion object {
        fun fromString(date: String): GroupByDateType {
            return values().first { it.date == date }
        }

        fun fromText(text: String): GroupByDateType {
            return values().first { it.getName() == text }
        }
    }

    @JsonValue
    open fun getType() = date

    @JsonValue
    open fun getName() = name.lowercase()

}
