package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class MediaType(val id: Int) {
    IMAGE(1),
    VIDEO(2),
    TEXT(3),
    TITLE(4),
    SITELINK(5),
    HTML5(6)
    ;

    companion object {
        fun fromId(id: Int): MediaType {
            return values().first { it.id == id }
        }

        fun fromText(text: String): MediaType {
            return values().first { it.getType() == text }
        }
    }

    @JsonValue
    open fun getType() = name.toLowerCase()

    fun isTextType(): Boolean {
        return this == TEXT || this == TITLE
    }
}
