package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.mobilecontent.model.OsType

enum class Platform(@JsonValue val id: Int) {
    ANDROID(1),
    IOS(2),
    ;

    companion object {
        fun fromId(id: Int): Platform {
            return values().first { it.id == id }
        }

        @JvmStatic
        @JsonCreator
        fun fromId(id: String): Platform {
            return fromId(id.toInt())
        }

        fun fromOsType(osType: OsType) =
            when (osType) {
                OsType.ANDROID -> ANDROID
                OsType.IOS -> IOS
            }
    }
}
