package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class Socdem(
    val genders: List<Gender>,
    val ageLower: AgePoint,
    val ageUpper: AgePoint,
    val incomeLower: IncomeGrade?, // минимальная граница дохода
    val incomeUpper: IncomeGrade?,
) {
    enum class IncomeGrade(override val goalId: Long, override val order: Int) : SocdemGoal {
        LOW(2499000009, 0),
        MIDDLE(2499000010, 1),
        HIGHER_THAN_MIDDLE(2499000011, 2),
        HIGH(2499000012, 3),
        PREMIUM(2499000013, 4),
    }
}
