package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class Status(val id: Int) {
    DRAFT(1),
    MODERATING(2),
    REJECTED(3),
    STARTED(4),
    STOPPED(5),
    ARCHIVED(6),
    ;

    companion object {
        fun fromId(id: Int): Status {
            return values().first { it.id == id }
        }
    }

    @JsonValue
    open fun getTargetStatus() = name.toLowerCase()
}
