package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class TargetStatus(val id: Int) {
    STARTED(1),
    STOPPED(2),
    ;

    companion object {
        fun fromId(id: Int): TargetStatus {
            return values().first { it.id == id }
        }
    }

    @JsonValue
    open fun getTargetStatus() = name.toLowerCase()
}
