package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Дублирует номера целей из [ru.yandex.direct.intapi.entity.rmp.campaigns.Target]
 */
enum class TargetType(@JsonValue val id: Long, val goalId: Long?) {
    INSTALL(1 shl 0, 4L),
    GOAL(1 shl 1, 38402972L),
    LAUNCH(1 shl 2, 38403008L),
    PAYMENT(1 shl 3, 38403053L),
    BASKET(1 shl 4, 38403071L),
    WISH_LIST(1 shl 5, 38403080L),
    REGISTER(1 shl 6, 38403095L),
    TRAIN(1 shl 7, 38403104L),
    ORDER(1 shl 8, 38403131L),
    BUY(1 shl 9, 38403173L),
    RATING(1 shl 10, 38403191L),
    SEARCH(1 shl 11, 38403197L),
    CREDITS(1 shl 12, 38403206L),
    LEVELUP(1 shl 13, 38403215L),
    WATCH(1 shl 14, 38403230L),
    TIMESPENT(1 shl 15, 38403338L),
    SHARE(1 shl 16, 38403494L),
    USER_1(1 shl 17, 38403530L),
    USER_2(1 shl 18, 38403545L),
    USER_3(1 shl 19, 38403581L),
    CPC(1 shl 20, 0L),
    ;

    companion object {
        fun fromId(id: Long): TargetType {
            return values().first { it.id == id }
        }

        /**
         * Jackson не умеет использовать численное `@JsonValue` для десериализации.
         * Также, для десериализации значений enum-а может использоваться только `@JsonCreator`, принимающий строку.
         * (в том числе для значений, которые сериализованы числом)
         */
        @JvmStatic
        @JsonCreator
        fun fromId(id: String): TargetType {
            return fromId(id.toLong())
        }
    }
}
