package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonProperty

data class UacAvatarsMeta(
    @JsonProperty("ColorWizBack")
    val colorWizBack: String,
    @JsonProperty("ColorWizButton")
    val colorWizButton: String,
    @JsonProperty("ColorWizButtonText")
    val colorWizButtonText: String,
    @JsonProperty("ColorWizText")
    val colorWizText: String,
    @JsonProperty("crc64")
    val crc64: String,
    @JsonProperty("orig-size")
    val origSize: UacImageSize,
    @JsonProperty("orig-format")
    val origFormat: String,
    @JsonProperty("orig-animated")
    val origAnimated: Boolean,
    @JsonProperty("orig-size-bytes")
    val origSizeBytes: Int,
    @JsonProperty("orig-orientation")
    val origOrientation: Int,

) {
    var trueOrigSize: UacImageSize

    init {
        trueOrigSize = if (needToRotate()) UacImageSize(origSize.height, origSize.width) else origSize
    }

    private fun needToRotate(): Boolean {
        return origOrientation > 4
    }
}

data class UacImageSize(
    @JsonProperty("x")
    val width: Int,
    @JsonProperty("y")
    val height: Int,
)
