package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.core.type.TypeReference
import ru.yandex.direct.avatars.client.model.AvatarInfo
import ru.yandex.direct.avatars.client.model.answer.ImageSize
import ru.yandex.direct.utils.JsonUtils

class UacAvatarsResponseInfo(
    avatarInfo: AvatarInfo
) {
    val uacAvatarsMeta: UacAvatarsMeta = JsonUtils.fromJson(
            JsonUtils.fromJson(avatarInfo.meta)["meta"],
            UacAvatarsMeta::class.java
    )
    val sizes: Map<String, ImageSize> = avatarInfo.sizes
    val groupId: Int = avatarInfo.groupId
    val name: String = avatarInfo.key
}
