package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
// Служебный класс для передачи в одном объекте все корректировки/ретаргетинги
data class UacComplexBidModifier(
    val advType: AdvType,
    val socdem: Socdem?,
    val deviceTypes: Set<DeviceType>?,
    val inventoryTypes: Set<InventoryType>?,
    // включена ли фича, разрашающая клиенту делать корректировки на SmartTV.
    val isSmartTVEnabled: Boolean = false,
    val isTabletModifierEnabled: Boolean = false,
)
