package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import java.math.BigDecimal
import java.time.LocalDate

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class UacStrategyData(
    val budget: BigDecimal? = null,
    val autoProlongation: Boolean? = null,
    val avgCpm: BigDecimal? = null,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    val finishDate: LocalDate? = null,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    val startDate: LocalDate? = null,
    val sum: BigDecimal? = null,
    val avgCpv: BigDecimal? = null,
    val crr: Long? = null,
    val avgCpa: BigDecimal? = null,
    val avgCpi: BigDecimal? = null,
    val avgBid: BigDecimal? = null,
    val payForConversion: Boolean? = null
)
