package ru.yandex.direct.core.entity.uac.model

import ru.yandex.direct.core.entity.campaign.model.StrategyName

enum class UacStrategyName {
    CPM_DEFAULT,
    AUTOBUDGET_AVG_CPV,
    AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD,
    AUTOBUDGET_MAX_REACH,
    AUTOBUDGET_MAX_IMPRESSIONS,
    AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD,
    AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD,
    AUTOBUDGET_CRR,
    AUTOBUDGET_AVG_CLICK,
    AUTOBUDGET_AVG_CPA,
    AUTOBUDGET_AVG_CPI;


    fun toDbStrategyName(): StrategyName = when (this) {
        CPM_DEFAULT -> StrategyName.CPM_DEFAULT
        AUTOBUDGET_AVG_CPV -> StrategyName.AUTOBUDGET_AVG_CPV
        AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD -> StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD
        AUTOBUDGET_MAX_REACH -> StrategyName.AUTOBUDGET_MAX_REACH
        AUTOBUDGET_MAX_IMPRESSIONS -> StrategyName.AUTOBUDGET_MAX_IMPRESSIONS
        AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD -> StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD
        AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD -> StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD
        AUTOBUDGET_CRR -> StrategyName.AUTOBUDGET_CRR
        AUTOBUDGET_AVG_CLICK -> StrategyName.AUTOBUDGET_AVG_CLICK
        AUTOBUDGET_AVG_CPA -> StrategyName.AUTOBUDGET_AVG_CPA
        AUTOBUDGET_AVG_CPI -> StrategyName.AUTOBUDGET_AVG_CPI
    }
}
