package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue


enum class UacStrategyPlatform(val id: Int) {
    SEARCH(1),
    CONTEXT(2),
    BOTH(3),
    ;

    companion object {
        fun fromId(id: Int): UacStrategyPlatform {
            return values().first { it.id == id }
        }
    }

    @JsonValue
    open fun getUacStrategyPlatform() = name.lowercase()
}
