package ru.yandex.direct.core.entity.uac.model.direct_ad

import com.fasterxml.jackson.annotation.JsonValue

enum class BannerModerationSubject(@JsonValue val id: Int) {
    TEXT(1),
    IMAGE(2),
    CREATIVE(3),
    SITELINKS_SET(4),
    ;

    companion object {
        private val B_ID = values().associateBy { it.id }

        fun fromId(id: Int): BannerModerationSubject = B_ID[id] ?: throw NoSuchElementException()
    }
}
