package ru.yandex.direct.core.entity.uac.model.direct_ad

import com.fasterxml.jackson.annotation.JsonValue

enum class DirectAdStatus(@JsonValue val id: Int) {
    CREATED(1),
    ERROR_UNKNOWN(2),
    MODERATING(3),
    ACTIVE(4),
    REJECTED(5),
    ARCHIVED(6),
    DELETED(7),
    ;

    companion object {
        private val B_ID = values().associateBy { it.id }

        fun fromId(id: Int): DirectAdStatus = B_ID[id] ?: throw NoSuchElementException()
    }
}
