package ru.yandex.direct.core.entity.uac.model.direct_content

import com.fasterxml.jackson.annotation.JsonValue

enum class DirectContentStatus(@JsonValue val id: Int) {
    CREATED(1),
    ERROR_UNKNOWN(2),
    ;

    companion object {
        private val B_ID = values().associateBy { it.id }

        fun fromId(id: Int): DirectContentStatus = B_ID[id] ?: throw NoSuchElementException()
    }
}
