package ru.yandex.direct.core.entity.uac.model.direct_content

import com.fasterxml.jackson.annotation.JsonValue

enum class DirectContentType(@JsonValue val id: Int) {
    IMAGE(1),
    VIDEO(2),
    HTML5(3),
    NON_SKIPPABLE_VIDEO(4),
    SITELINKS_SET(5),
    ;

    companion object {
        private val B_ID = values().associateBy { it.id }

        fun fromId(id: Int): DirectContentType = B_ID[id] ?: throw NoSuchElementException()
    }
}
