package ru.yandex.direct.core.entity.uac.model.relevance_match

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory.RMC_EXACT_MARK_VALUE
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory.RMC_ALTERNATIVE_MARK_VALUE
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory.RMC_BROADER_MARK_VALUE
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory.RMC_COMPETITOR_MARK_VALUE
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory.RMC_ACCESSORY_MARK_VALUE

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacRelevanceMatch(
    val active: Boolean,                                // включен ли выбор категорий автотаргетинга
    val categories: Set<UacRelevanceMatchCategory>,     // категории автотаргетинга
)

enum class UacRelevanceMatchCategory(val typedValue: String, val id: Int) {
    // Порядок важен. Используется при конвертации категории из грута в модель кампании и обратно
    EXACT_MARK("exact_mark", RMC_EXACT_MARK_VALUE),                   // точное соответствие
    ALTERNATIVE_MARK("alternative_mark", RMC_ALTERNATIVE_MARK_VALUE), // широкое соответствие, альтернатива
    COMPETITOR_MARK("competitor_mark", RMC_COMPETITOR_MARK_VALUE),    // широкое соответствие, конкурент
    BROADER_MARK("broader_mark", RMC_BROADER_MARK_VALUE),             // широкое соответствие, шире
    ACCESSORY_MARK("accessory_mark", RMC_ACCESSORY_MARK_VALUE),       // широкое соответствие, сопутствующий
    ;

    companion object {
        fun fromTypedValue(typedValue: String?): UacRelevanceMatchCategory? =
            when (typedValue) {
                EXACT_MARK.typedValue -> EXACT_MARK
                ALTERNATIVE_MARK.typedValue -> ALTERNATIVE_MARK
                COMPETITOR_MARK.typedValue -> COMPETITOR_MARK
                BROADER_MARK.typedValue -> BROADER_MARK
                ACCESSORY_MARK.typedValue -> ACCESSORY_MARK
                else -> null
            }

        fun fromId(id: Int?): UacRelevanceMatchCategory? =
            when (id) {
                EXACT_MARK.id -> EXACT_MARK
                ALTERNATIVE_MARK.id -> ALTERNATIVE_MARK
                COMPETITOR_MARK.id -> COMPETITOR_MARK
                BROADER_MARK.id -> BROADER_MARK
                ACCESSORY_MARK.id -> ACCESSORY_MARK
                else -> null
            }
    }
}

fun toRelevanceMatchCategory(
    uacRelevanceMatchCategory: UacRelevanceMatchCategory
): RelevanceMatchCategory = RelevanceMatchCategory.fromTypedValue(uacRelevanceMatchCategory.typedValue)
