package ru.yandex.direct.core.entity.uac.model.relevance_match

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.relevancematch.Constants.DISABLED_RELEVANCE_MATCH_CATEGORIES
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacRelevanceMatchCategoryItem(
    val selected: Boolean,  // выбрана ли категория
    val disabled: Boolean,  // может ли пользователь менять категорию
    val relevanceMatchCategory: UacRelevanceMatchCategory,
)


fun toUacRelevanceMatchCategoryItem(
    relevanceMatchCategory: UacRelevanceMatchCategory,
    selected: Boolean = false,
) = UacRelevanceMatchCategoryItem(
    selected = selected,
    disabled = DISABLED_RELEVANCE_MATCH_CATEGORIES.contains(
        RelevanceMatchCategory.fromTypedValue(relevanceMatchCategory.typedValue)),
    relevanceMatchCategory = relevanceMatchCategory,
)
