package ru.yandex.direct.core.entity.uac.model.request

import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.DeviceType
import ru.yandex.direct.core.entity.uac.model.Socdem
import ru.yandex.direct.core.entity.uac.model.UacAdjustment
import ru.yandex.direct.core.entity.uac.model.UacFeedFilter
import ru.yandex.direct.core.entity.uac.model.UacGoal
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.entity.uac.model.UacShowsFrequencyLimit
import ru.yandex.direct.core.entity.uac.model.relevance_match.UacRelevanceMatch
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacBrandsafety
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCampaignMeasurer
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCpmAsset
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacDisabledPlaces
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.core.grut.api.AdGroupBriefGrutModel

data class UacAdGroupBrief(
    val campaignId: String,
    val advType: AdvType,
    val appId: String?,
    val goals: List<UacGoal>?,
    val counters: List<Int>?,
    val isEcom: Boolean?,
    val feedId: Long?,
    val feedFilters: List<UacFeedFilter>?,
    val trackingUrl: String?,
    val impressionUrl: String?,
    val permalinkId: Long?,
    val phoneId: Long?,
    val trackingParams: String? = null,
    val bizLandingId: Long? = null,
    val showTitleAndBody: Boolean? = null,
    val zenPublisherId: String? = null,

    val name: String?,
    val url: String,
    val regions: List<Long>?,
    val minusRegions: List<Long>?,
    val hyperGeoId: Long?,
    val keywords: List<String>?,
    val minusKeywords: List<String>?,
    val socdem: Socdem?,
    val deviceTypes: Set<DeviceType>?,
    val retargetingCondition: UacRetargetingCondition?,
    val videosAreNonSkippable: Boolean?,
    val brandSurveyId: String?,
    val showsFrequencyLimit: UacShowsFrequencyLimit?,
    val cpmAssets: Map<String, UacCpmAsset>?,
    val campaignMeasurers: List<UacCampaignMeasurer>?,
    val uacBrandsafety: UacBrandsafety?,
    val uacDisabledPlaces: UacDisabledPlaces?,
    val assetLinks: List<UacYdbCampaignContent>? = null,
    var adjustments: List<UacAdjustment>? = null,
    val relevanceMatch: UacRelevanceMatch? = null,

    val adGroupBriefId: Long?,
    val adGroupIds: Set<Long>?,
    val catalogIds: List<Long>?,
)

fun createBrief(
    campaignBrief: UacYdbCampaign,
    adGroupBriefGrutModel: AdGroupBriefGrutModel?
): UacAdGroupBrief {
    return UacAdGroupBrief(
        campaignId = campaignBrief.id,
        advType = campaignBrief.advType,
        appId = campaignBrief.appId,
        goals = campaignBrief.goals,
        counters = campaignBrief.counters,
        isEcom = campaignBrief.isEcom,
        feedId = campaignBrief.feedId,
        feedFilters = campaignBrief.feedFilters,
        trackingUrl = campaignBrief.trackingUrl,
        impressionUrl = campaignBrief.impressionUrl,
        permalinkId = campaignBrief.permalinkId,
        phoneId = campaignBrief.phoneId,
        trackingParams = campaignBrief.trackingParams,
        bizLandingId = campaignBrief.bizLandingId,
        showTitleAndBody = campaignBrief.showTitleAndBody,
        zenPublisherId = campaignBrief.zenPublisherId,

        name = adGroupBriefGrutModel?.name ?: campaignBrief.name,
        url = adGroupBriefGrutModel?.url ?: campaignBrief.storeUrl,
        regions = adGroupBriefGrutModel?.regions ?: campaignBrief.regions,
        minusRegions = adGroupBriefGrutModel?.minusRegions ?: campaignBrief.minusRegions,
        hyperGeoId = adGroupBriefGrutModel?.hyperGeoId ?: campaignBrief.hyperGeoId,
        keywords = adGroupBriefGrutModel?.keywords ?: campaignBrief.keywords,
        minusKeywords = adGroupBriefGrutModel?.minusKeywords ?: campaignBrief.minusKeywords,
        socdem = adGroupBriefGrutModel?.socdem ?: campaignBrief.socdem,
        deviceTypes = adGroupBriefGrutModel?.deviceTypes ?: campaignBrief.deviceTypes,
        retargetingCondition = adGroupBriefGrutModel?.retargetingCondition ?: campaignBrief.retargetingCondition,
        videosAreNonSkippable = adGroupBriefGrutModel?.videosAreNonSkippable ?: campaignBrief.videosAreNonSkippable,
        brandSurveyId = adGroupBriefGrutModel?.brandSurveyId ?: campaignBrief.brandSurveyId,
        showsFrequencyLimit = adGroupBriefGrutModel?.showsFrequencyLimit ?: campaignBrief.showsFrequencyLimit,
        cpmAssets = adGroupBriefGrutModel?.cpmAssets ?: campaignBrief.cpmAssets,
        campaignMeasurers = adGroupBriefGrutModel?.campaignMeasurers ?: campaignBrief.campaignMeasurers,
        uacBrandsafety = adGroupBriefGrutModel?.uacBrandsafety ?: campaignBrief.uacBrandsafety,
        uacDisabledPlaces = adGroupBriefGrutModel?.uacDisabledPlaces ?: campaignBrief.uacDisabledPlaces,
        assetLinks = adGroupBriefGrutModel?.assetLinks ?: campaignBrief.assetLinks,
        adjustments = adGroupBriefGrutModel?.adjustments ?: campaignBrief.adjustments,
        relevanceMatch = adGroupBriefGrutModel?.relevanceMatch ?: campaignBrief.relevanceMatch,

        adGroupBriefId = adGroupBriefGrutModel?.id,
        adGroupIds = adGroupBriefGrutModel?.adGroupIds?.toSet(),
        catalogIds = adGroupBriefGrutModel?.catalogIds,
    )
}
