package ru.yandex.direct.core.entity.uac.operation

import ru.yandex.direct.result.Result
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

abstract class CheckableOperation<P, A> {
    private var prepared = false
    private var applied = false

    fun prepareWithCheck(): ValidationResult<P, Defect<*>> {
        checkPrepare()
        return prepare()
    }

    private fun checkPrepare() {
        check(!prepared) { "Operation was already prepared" }
        prepared = true
    }

    protected abstract fun prepare(): ValidationResult<P, Defect<*>>

    fun applyWithCheck(): Result<A> {
        checkApply()
        return apply()
    }

    private fun checkApply() {
        check(prepared) { "Operation is not prepared" }
        check(!applied) { "Operation was already applied" }
        applied = true
    }

    protected abstract fun apply(): Result<A>

    fun prepareAndApplyWithCheck(): Result<A> {
        val preparationResult = prepareWithCheck()
        if (preparationResult.hasAnyErrors()) {
            return Result.broken(preparationResult)
        }
        return applyWithCheck()
    }
}
