package ru.yandex.direct.core.entity.uac.operation

import ru.yandex.direct.core.entity.uac.model.UacAvatarsResponseInfo
import ru.yandex.direct.core.entity.uac.service.UacAvatarsService
import ru.yandex.direct.result.Result
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

open class UacUploadImageByUrlToAvatarsOperation(
    private val uacAvatarsService: UacAvatarsService,
    private val url: String
): CheckableOperation<String, UacAvatarsResponseInfo>() {

    override fun prepare(): ValidationResult<String, Defect<*>> {
        return ValidationResult.success(url)
    }

    override fun apply(): Result<UacAvatarsResponseInfo> {
        return uacAvatarsService.uploadImageByUrl(url, null)
    }
}
