package ru.yandex.direct.core.entity.uac.repository.mysql

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate
import ru.yandex.direct.core.entity.banner.model.BannerFlags
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate
import ru.yandex.direct.core.entity.banner.model.old.StatusSitelinksModerate
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES
import ru.yandex.direct.dbutil.wrapper.DslContextProvider


data class BannerStatusesInfo(
    val bannerId: Long,
    val campaignId: Long,
    val statusModerate: BannerStatusModerate,
    val imageStatusModerate: StatusBannerImageModerate?,
    val creativeStatusModerate: BannerCreativeStatusModerate?,
    val siteLinksSetStatusModerate: StatusSitelinksModerate?,
    val flags: BannerFlags?,
)

@Repository
class BannerStatusesRepository(
    private val dslContextProvider: DslContextProvider
) {

    fun getBannerStatusesInfo(shard: Int, bannerIds: Collection<Long>): List<BannerStatusesInfo> {
        return getBannerStatusesInfo(shard, bannerIds, null)
    }

    fun getBannerStatusesInfoByAdGroupIds(shard: Int, adgroupIds: Collection<Long>): List<BannerStatusesInfo> {
        return getBannerStatusesInfo(shard, adgroupIds = adgroupIds)
    }

    private fun getBannerStatusesInfo(shard: Int, bannerIds: Collection<Long>? = null, adgroupIds: Collection<Long>? = null): List<BannerStatusesInfo> {
        val predicate = when {
            bannerIds != null -> {
                BANNERS.BID.`in`(bannerIds)
            }
            adgroupIds != null -> {
                BANNERS.PID.`in`(adgroupIds)
            }
            else -> {
                throw IllegalArgumentException("bannerIds or adGroupIds must be not null")
            }
        }
        return dslContextProvider.ppc(shard)
            .select(BANNERS.BID, BANNERS.CID, BANNERS.STATUS_MODERATE, BANNERS.FLAGS, BANNERS_PERFORMANCE.STATUS_MODERATE, BANNER_IMAGES.STATUS_MODERATE, BANNERS.STATUS_SITELINKS_MODERATE)
            .from(BANNERS)
            .leftJoin(BANNERS_PERFORMANCE)
            .on(BANNERS.BID.eq(BANNERS_PERFORMANCE.BID))
            .leftJoin(BANNER_IMAGES)
            .on(BANNERS.BID.eq(BANNER_IMAGES.BID))
            .where(predicate)
            .fetch {
                BannerStatusesInfo(
                    bannerId = it[BANNERS.BID],
                    campaignId = it[BANNERS.CID],
                    statusModerate = BannerStatusModerate.fromSource(it[BANNERS.STATUS_MODERATE])!!,
                    imageStatusModerate = StatusBannerImageModerate.fromSource(it[BANNER_IMAGES.STATUS_MODERATE]),
                    creativeStatusModerate = BannerCreativeStatusModerate.fromSource(it[BANNERS_PERFORMANCE.STATUS_MODERATE]),
                    siteLinksSetStatusModerate = StatusSitelinksModerate.fromSource(it[BANNERS.STATUS_SITELINKS_MODERATE]),
                    flags = BannerFlags.fromSource(it[BANNERS.FLAGS])
                )
            }

    }
}
