package ru.yandex.direct.core.entity.uac.repository.stat

import java.util.Timer
import javax.annotation.PreDestroy
import org.springframework.stereotype.Component
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser
import ru.yandex.inside.yt.kosher.cypress.YPath

/**
 * Выбирает кластер для чтения таблиц, необходимых для получения статистики по ассетам
 */
@Component
class AssetsStatContextProvider(
    ytDynamicConfig: YtDynamicConfig,
    config: DirectYtDynamicConfig,
    ytProvider: YtProvider,
) {
    companion object {
        private const val FRESHNESS_ATTRIBUTE = "@last_sync_time"
    }

    private val timer: Timer = Timer(javaClass.simpleName + "-Timer", true)

    private val attributeBasedClusterChooser = AttributeBasedClusterChooser(
        timer,
        config.clusterRefreshPeriod,
        ytProvider,
        config.assetsStatClusters,
        YPath.simple(config.tables().yabsStat().assetsStatTablePath()),
        FRESHNESS_ATTRIBUTE,
        AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR
    )

    private val ytDynamicContextProvider: YtDynamicContextProvider<*> = YtDynamicContextProvider(
        attributeBasedClusterChooser,
        ytProvider,
        ytDynamicConfig.defaultSelectRowsTimeout()
    )

    @PreDestroy
    fun stopTimer() {
        timer.cancel()
    }

    fun getContext(): YtDynamicContext {
        return ytDynamicContextProvider.context
    }
}
