package ru.yandex.direct.core.entity.uac.repository.ydb

import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Repository
import ru.yandex.direct.common.configuration.UacYdbConfiguration
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.RecommendedCostType
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbRecommendedCost
import ru.yandex.direct.core.entity.uac.repository.ydb.schema.RECOMMENDED_COST
import ru.yandex.direct.core.entity.uac.repository.ydb.schema.RecommendedCostTable
import ru.yandex.direct.ydb.YdbPath
import ru.yandex.direct.ydb.builder.querybuilder.InsertBuilder
import ru.yandex.direct.ydb.builder.querybuilder.SelectBuilder.select
import ru.yandex.direct.ydb.client.YdbClient
import ru.yandex.direct.ydb.table.temptable.TempTableBuilder.Companion.buildTempTable

@Lazy
@Repository
class UacYdbRecommendedCostRepository(
    @Qualifier(UacYdbConfiguration.UAC_YDB_CLIENT_BEAN) var ydbClient: YdbClient,
    @Qualifier(UacYdbConfiguration.UAC_YDB_PATH_BEAN) var path: YdbPath,
) {
    fun getRecommendedCostByCategoryAndPlatform(
        category: String, platform: Platform
    ): Map<RecommendedCostType, Long> {
        val recommendedCostCategoryIndex = RECOMMENDED_COST.withIndex(RECOMMENDED_COST.RECOMMENDED_COST_CATEGORY_INDEX) as RecommendedCostTable
        val queryBuilder = select(
            recommendedCostCategoryIndex.RECOMMENDED_COST,
            recommendedCostCategoryIndex.TYPE,
        )
            .from(recommendedCostCategoryIndex)
            .where(recommendedCostCategoryIndex.CATEGORY.eq(category)
                .and(recommendedCostCategoryIndex.PLATFORM.eq(platform.id)))

        val queryAndParams = queryBuilder.queryAndParams(path)
        val result = ydbClient.executeOnlineRoQuery(queryAndParams, true).getResultSet(0)

        val recommendedCost: MutableMap<RecommendedCostType, Long> = mutableMapOf()
        while (result.next()) {
            val type = result.getValueReader(recommendedCostCategoryIndex.TYPE)!!.uint32.toInt()
            val cost = result.getValueReader(recommendedCostCategoryIndex.RECOMMENDED_COST)!!.uint64
            recommendedCost[RecommendedCostType.fromId(type)] = cost
        }
        return recommendedCost
    }
}
