package ru.yandex.direct.core.entity.uac.repository.ydb

import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Repository
import ru.yandex.direct.common.configuration.UacYdbConfiguration
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdString
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbUser
import ru.yandex.direct.core.entity.uac.repository.ydb.schema.USER
import ru.yandex.direct.core.entity.uac.repository.ydb.schema.UserTable
import ru.yandex.direct.ydb.YdbPath
import ru.yandex.direct.ydb.builder.querybuilder.InsertBuilder.insertInto
import ru.yandex.direct.ydb.builder.querybuilder.SelectBuilder.select
import ru.yandex.direct.ydb.client.YdbClient
import ru.yandex.direct.ydb.table.temptable.TempTableBuilder.Companion.buildTempTable

@Lazy
@Repository
class UacYdbUserRepository(
    @Qualifier(UacYdbConfiguration.UAC_YDB_CLIENT_BEAN) var ydbClient: YdbClient,
    @Qualifier(UacYdbConfiguration.UAC_YDB_PATH_BEAN) var path: YdbPath,
) {
    fun getUserByUid(uid: Long): UacYdbUser? {
        val userIndex = USER.withIndex(USER.UID_INDEX) as UserTable
        val queryBuilder = select(userIndex.ID, userIndex.UID, userIndex.CREATED_AT)
            .from(userIndex)
            .where(userIndex.UID.eq(uid))

        val queryAndParams = queryBuilder.queryAndParams(path)
        val result = ydbClient.executeOnlineRoQuery(queryAndParams, true).getResultSet(0)

        if (!result.next()) {
            return null
        }

        return UacYdbUser(
            id = result.getValueReader(userIndex.ID).uint64.toIdString(),
            uid = result.getValueReader(userIndex.UID).uint64,
            createdAt = UacYdbUtils.fromEpochSecond(result.getValueReader(userIndex.CREATED_AT).uint64),
        )
    }

    fun saveUser(user: UacYdbUser) {
        val insertValues = buildTempTable {
            value(USER.ID, user.id.toIdLong())
            value(USER.UID, user.uid)
            value(USER.CREATED_AT, UacYdbUtils.toEpochSecond(user.createdAt))
        }

        val queryAndParams = insertInto(USER)
            .selectAll()
            .from(insertValues)
            .queryAndParams(path)

        ydbClient.executeQuery(queryAndParams, true)
    }
}
