package ru.yandex.direct.core.entity.uac.repository.ydb.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.banner.model.BannerMeasurerSystem

enum class UacBannerMeasurerSystem(private val coreBannerMeasurerSystem: BannerMeasurerSystem) {
    NO(BannerMeasurerSystem.NO),

    ADMETRICA(BannerMeasurerSystem.ADMETRICA),

    MEDIASCOPE(BannerMeasurerSystem.MEDIASCOPE),

    ADLOOX(BannerMeasurerSystem.ADLOOX),

    MOAT(BannerMeasurerSystem.MOAT),

    DV(BannerMeasurerSystem.DV),

    ADRIVER(BannerMeasurerSystem.ADRIVER),

    SIZMEK(BannerMeasurerSystem.SIZMEK),

    INTEGRAL_AD_SCIENCE(BannerMeasurerSystem.INTEGRAL_AD_SCIENCE),

    WEBORAMA(BannerMeasurerSystem.WEBORAMA),

    OMI(BannerMeasurerSystem.OMI);

    fun toCoreBannerMeasurerSystem():BannerMeasurerSystem {
        return this.coreBannerMeasurerSystem;
    }

    companion object {
        //https://github.com/FasterXML/jackson-module-kotlin/issues/75
        @JsonCreator
        @JvmStatic
        fun fromStringRepresentation(key: String): UacBannerMeasurerSystem = valueOf(key.uppercase())
    }

    @JsonValue
    open fun getType() = name.toLowerCase()
}
