package ru.yandex.direct.core.entity.uac.repository.ydb.model

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.banner.model.ButtonAction

enum class UacButtonAction(private val coreButtonAction: ButtonAction) {
    GO_TO_WEBSITE(ButtonAction.GO_TO_WEBSITE),
    MORE(ButtonAction.MORE),
    GET_PRICE(ButtonAction.GET_PRICE),
    GET_OFFER(ButtonAction.GET_OFFER),
    APPLY(ButtonAction.APPLY),
    BOOK(ButtonAction.BOOK),
    REGISTER(ButtonAction.REGISTER),
    SUBSCRIBE(ButtonAction.SUBSCRIBE),
    CHOOSE(ButtonAction.CHOOSE),
    TRY(ButtonAction.TRY),
    WATCH(ButtonAction.WATCH),
    TURN_ON(ButtonAction.TURN_ON),
    LISTEN(ButtonAction.LISTEN),
    PLAY(ButtonAction.PLAY),
    START(ButtonAction.START),
    BUY(ButtonAction.BUY),
    DOWNLOAD(ButtonAction.DOWNLOAD),
    INSTALL(ButtonAction.INSTALL),
    ARROW(ButtonAction.ARROW),
    CUSTOM_TEXT(ButtonAction.CUSTOM_TEXT)
    ;

    companion object {
        fun fromName(name: String): UacButtonAction {
            return values().first { it.name == name }
        }

        //https://github.com/FasterXML/jackson-module-kotlin/issues/75
        @JsonCreator
        @JvmStatic
        fun fromStringRepresentation(key: String): UacButtonAction = valueOf(key.uppercase())
    }

    fun toCoreButtonAction(): ButtonAction {
        return this.coreButtonAction;
    }

    @JsonValue
    open fun getType() = name.lowercase()
}

