package ru.yandex.direct.core.entity.uac.repository.ydb.model

import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.Store
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils
import java.time.LocalDateTime

data class UacYdbAppInfo(
    val pkVersion: Int = 1,
    val appId: String,
    val bundleId: String?,
    val language: String,
    val region: String,
    val platform: Platform,
    val source: Store,
    val data: String,
    val updatedAt: LocalDateTime = LocalDateTime.now(),
    val id: String = UacYdbUtils.cityHash64(
        appId,
        region,
        language,
        platform.id,
        source.id,
    )
)
