package ru.yandex.direct.core.entity.uac.repository.ydb.model

import java.math.BigDecimal
import java.time.LocalDateTime
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.DeviceType
import ru.yandex.direct.core.entity.uac.model.DirectCampaignStatus
import ru.yandex.direct.core.entity.uac.model.InventoryType
import ru.yandex.direct.core.entity.uac.model.Socdem
import ru.yandex.direct.core.entity.uac.model.TargetStatus
import ru.yandex.direct.core.entity.uac.model.TargetType
import ru.yandex.direct.core.entity.uac.model.TimeTarget
import ru.yandex.direct.core.entity.uac.model.UacAdjustment
import ru.yandex.direct.core.entity.uac.model.UacCampaignOptions
import ru.yandex.direct.core.entity.uac.model.UacFeedFilter
import ru.yandex.direct.core.entity.uac.model.UacGoal
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.entity.uac.model.UacShowsFrequencyLimit
import ru.yandex.direct.core.entity.uac.model.UacStrategy
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform
import ru.yandex.direct.core.entity.uac.model.relevance_match.UacRelevanceMatch

data class UacYdbCampaign(
    val id: String,
    val name: String,
    val cpa: BigDecimal?,
    val crr: Long?,
    val weekLimit: BigDecimal?,
    val regions: List<Long>?,
    val minusRegions: List<Long>?,
    val storeUrl: String,
    val appId: String?,
    val targetId: TargetType?,
    val trackingUrl: String?,
    val account: String,
    val impressionUrl: String?,
    val createdAt: LocalDateTime,
    val updatedAt: LocalDateTime,
    val startedAt: LocalDateTime?,
    val advType: AdvType,
    val targetStatus: TargetStatus,
    val contentFlags: Map<String, Any>?,
    val options: UacCampaignOptions?,
    val skadNetworkEnabled: Boolean?,
    val adultContentEnabled: Boolean?,
    val hyperGeoId: Long?,
    val keywords: List<String>?,
    val minusKeywords: List<String>?,
    val socdem: Socdem?,
    val deviceTypes: Set<DeviceType>?,
    var inventoryTypes: Set<InventoryType>?,
    val goals: List<UacGoal>?,
    val counters: List<Int>?,
    val permalinkId: Long?,
    val phoneId: Long?,
    val calltrackingSettingsId: Long?,
    val timeTarget: TimeTarget?,
    val strategy: UacStrategy?,
    val retargetingCondition: UacRetargetingCondition?,
    val videosAreNonSkippable: Boolean?,
    val brandSurveyId: String?,
    val showsFrequencyLimit: UacShowsFrequencyLimit?,
    val briefSynced: Boolean?,
    val strategyPlatform: UacStrategyPlatform?,
    val isEcom: Boolean?,
    val feedId: Long?,
    val feedFilters: List<UacFeedFilter>?,
    val cpmAssets: Map<String, UacCpmAsset>?,
    val campaignMeasurers: List<UacCampaignMeasurer>?,
    val uacBrandsafety: UacBrandsafety?,
    val uacDisabledPlaces: UacDisabledPlaces?,
    val showTitleAndBody: Boolean? = null,
    val searchLift: UacSearchLift? = null,

    // GrUT stuff
    val assetLinks: List<UacYdbCampaignContent>? = null,
    val directCampaignStatus: DirectCampaignStatus? = null,
    var adjustments: List<UacAdjustment>? = null,
    val zenPublisherId: String? = null,
    val trackingParams: String? = null,
    val recommendationsManagementEnabled: Boolean? = null,
    val priceRecommendationsManagementEnabled: Boolean? = null,
    val relevanceMatch: UacRelevanceMatch? = null,
    val bizLandingId: Long? = null,
    val audienceSegmentsSynchronized: Boolean? = null,
) {
    val isDraft: Boolean = startedAt == null
}
