package ru.yandex.direct.core.entity.uac.repository.ydb.model

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData
import ru.yandex.direct.core.entity.uac.model.AssetLinkType
import ru.yandex.direct.core.entity.uac.model.CampaignContentStatus
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils
import java.time.LocalDateTime
import ru.yandex.grut.objects.proto.client.Schema

data class UacYdbCampaignContent(
    val id: String = UacYdbUtils.generateUniqueRandomId(),
    val campaignId: String,
    val contentId: String? = null,
    val type: MediaType?,
    val order: Int,
    val text: String? = null,
    val createdAt: LocalDateTime = LocalDateTime.now(),
    val removedAt: LocalDateTime? = null,
    val status: CampaignContentStatus,
    val rejectReasons: List<ModerationDiagData>? = null,
    val sitelink: Sitelink? = null,

    // GrUT stuff
    val linkType: AssetLinkType? = null,
    // нужно для джобы создания баннеров, версия с ydb получает по этой таблице image_hash из видео из direct_content, которая legacy
    // и в GrUT не поддержана. Аналогичную инфромацию можно получить из таблицы assets, но дополнительно ходить за ассетами будет накладно,
    // так как для заполнения этого класса мы уже это сделали так что самое оптимальное сохранить результат тут
    val asset: Schema.TAsset? = null,
)
