package ru.yandex.direct.core.entity.uac.repository.ydb.model

import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils

data class UacTrackerUrlStat(
    val trackerUrl: String,
    val counterType: CounterType,
    val hitCount: Long,
    val conversionsByEvent: Map<TrackerAppEvent, Long>
)

enum class CounterType(val id: Int) {
    VIEW(1),
    CLICK(2);

    companion object {
        fun fromId(id: Int): CounterType {
            return values().first {it.id == id}
        }
    }
}

enum class TrackerAppEvent {
    ACHIEVED_LEVEL,
    ADDED_PAYMENT_INFO,
    ADDED_TO_CART,
    ADDED_TO_WISHLIST,
    APP_LAUNCHED,
    COMPLETED_REGISTRATION,
    COMPLETED_TUTORIAL,
    CUSTOM_EVENT,
    EVENT_1,
    EVENT_2,
    EVENT_3,
    INITIATED_CHECKOUT,
    INSTALLED,
    PURCHASED,
    RATED,
    REMOVED_FROM_CART,
    SEARCHED,
    SHARED,
    SPENT_CREDITS,
    SPENT_TIME_IN_APP,
    UNLOCKED_ACHIEVEMENT,
    VIEWED_CONTENT;

    @JsonValue
    open fun getName() = name.lowercase()
}
