package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.Table
import ru.yandex.direct.ydb.table.TableWithIndexes

class AccountTable(name: String = "account", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val FEATURES = Column<String?>(this, "features", PrimitiveType.json())
    val CREATED_AT = Column<Long>(this, "created_at", PrimitiveType.uint64())
    val DIRECT_CLIENT_ID = Column<Long>(this, "direct_client_id", PrimitiveType.uint64())
    val UID = Column<Long>(this, "uid", PrimitiveType.uint64())

    private val COLUMNS = listOf(
        ID,
        FEATURES,
        CREATED_AT,
        DIRECT_CLIENT_ID,
        UID,
    )

    val ACCOUNT_CLIENT_ID_INDEX = Index(this, DIRECT_CLIENT_ID, "direct_client_id")

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(ACCOUNT_CLIENT_ID_INDEX)
    override fun getInstance(realName: String, alias: String?) = AccountTable(realName, alias)
}
