package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class AppInfoBundleIdIndexTable(name: String = "app_info_bundle_id_index", alias: String? = null) : TableWithIndexes(name, alias) {
    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val BUNDLE_ID = Column<String?>(this, "bundle_id", PrimitiveType.utf8())

    val BUNDLE_ID_INDEX = Index(this, BUNDLE_ID, "bundle_id")

    private val COLUMNS = listOf(
        ID,
        BUNDLE_ID
    )

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(BUNDLE_ID_INDEX)

    override fun getInstance(realName: String, alias: String?) = AppInfoBundleIdIndexTable(realName, alias)
}
