package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Table

class AppInfoTable : Table("app_info") {

	val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
	val PK_VERSION = Column<Int>(this, "pk_version", PrimitiveType.uint32())
	val APP_ID = Column<String>(this, "app_id", PrimitiveType.utf8())
    val BUNDLE_ID = Column<String?>(this, "bundle_id", PrimitiveType.utf8())
	val LANGUAGE = Column<String>(this, "language", PrimitiveType.utf8())
	val REGION = Column<String>(this, "region", PrimitiveType.utf8())
	val PLATFORM = Column<Int>(this, "platform", PrimitiveType.uint32())
	val SOURCE = Column<Int>(this, "source", PrimitiveType.uint32())
	val DATA = Column<String>(this, "data", PrimitiveType.jsonDocument())
	val UPDATED_AT = Column<Long>(this, "updated_at", PrimitiveType.uint64())

    private val COLUMNS = listOf(
        ID,
		PK_VERSION,
		APP_ID,
        BUNDLE_ID,
		LANGUAGE,
		REGION,
		PLATFORM,
		SOURCE,
		DATA,
		UPDATED_AT,
    )

    override fun getColumns() = COLUMNS
}
