package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.Table
import ru.yandex.direct.ydb.table.TableWithIndexes

class CampaignContentTable(name: String = "campaign_content", alias: String? = null) : TableWithIndexes(name, alias) {
    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val CAMPAIGN_ID = Column<Long>(this, "campaign_id", PrimitiveType.uint64())
    val CONTENT_ID = Column<Long?>(this, "content_id", PrimitiveType.uint64())
    val TYPE = Column<Int>(this, "type", PrimitiveType.uint32())
    val ORDER = Column<Int>(this, "order", PrimitiveType.uint32())
    val TEXT = Column<String?>(this, "text", PrimitiveType.utf8())
    val CREATED_AT = Column<Long>(this, "created_at", PrimitiveType.uint64())
    val REMOVED_AT = Column<Long?>(this, "removed_at", PrimitiveType.uint64())
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())
    val REJECT_REASONS = Column<String?>(this, "reject_reasons", PrimitiveType.json())
    val SITELINK = Column<String?>(this, "sitelink", PrimitiveType.json())

    val CAMPAIGN_CONTENT_CAMPAIGN_ID_INDEX = Index(this, CAMPAIGN_ID, "campaign")
    private val COLUMNS = listOf(
        ID,
        CAMPAIGN_ID,
        CONTENT_ID,
        TYPE,
        ORDER,
        TEXT,
        CREATED_AT,
        REMOVED_AT,
        STATUS,
        REJECT_REASONS,
        SITELINK
    )

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(CAMPAIGN_CONTENT_CAMPAIGN_ID_INDEX)

    override fun getInstance(realName: String, alias: String?) = CampaignContentTable(realName, alias)
}
