package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class CampaignTable(name: String = "campaign", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val ADV_TYPE = Column<Int>(this, "adv_type", PrimitiveType.uint32())
    val NAME = Column<String>(this, "name", PrimitiveType.utf8())
    val STORE_URL = Column<String>(this, "store_url", PrimitiveType.utf8())
    val APP_ID = Column<Long?>(this, "app_id", PrimitiveType.uint64())
    val APP_TITLE = Column<String>(this, "app_title", PrimitiveType.utf8())
    val REGIONS = Column<String>(this, "regions", PrimitiveType.json())
    val MINUS_REGIONS = Column<String?>(this, "minus_regions", PrimitiveType.json())
    val TRACKING_URL = Column<String?>(this, "tracking_url", PrimitiveType.utf8())
    val IMPRESSION_URL = Column<String?>(this, "impression_url", PrimitiveType.utf8())
    val TARGET_ID = Column<Long?>(this, "target_id", PrimitiveType.uint64())
    val CPA = Column<Long?>(this, "cpa", PrimitiveType.uint64())
    val WEEK_LIMIT = Column<Long?>(this, "week_limit", PrimitiveType.uint64())
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())
    val TARGET_STATUS = Column<Int>(this, "target_status", PrimitiveType.uint32())
    val CREATED_AT = Column<Long>(this, "created_at", PrimitiveType.uint64())
    val UPDATED_AT = Column<Long>(this, "updated_at", PrimitiveType.uint64())
    val STARTED_AT = Column<Long?>(this, "started_at", PrimitiveType.uint64())
    val CONTENT_FLAGS = Column<String?>(this, "content_flags", PrimitiveType.json())
    val STATE_REASONS = Column<String?>(this, "state_reasons", PrimitiveType.json())
    val OPTIONS = Column<String?>(this, "options", PrimitiveType.json())
    val ACCOUNT_ID = Column<Long>(this, "account_id", PrimitiveType.uint64())
    val SKAD_NETWORK_ENABLED = Column<Boolean?>(this, "skad_network_enabled", PrimitiveType.bool())
    val ADULT_CONTENT_ENABLED = Column<Boolean?>(this, "adult_content_enabled", PrimitiveType.bool())
    val HYPERGEO_ID = Column<Long?>(this, "hypergeo_id", PrimitiveType.uint64())
    val KEYWORDS = Column<String?>(this, "keywords", PrimitiveType.json())
    val MINUS_KEYWORDS = Column<String?>(this, "minus_keywords", PrimitiveType.json())
    val SOCDEM = Column<String?>(this, "socdem", PrimitiveType.json())
    val DEVICE_TYPES = Column<String?>(this, "device_types", PrimitiveType.json())
//    val INVENTORY_TYPES = Column<String?>(this, "inventory_types", PrimitiveType.json())
    val GOALS = Column<String?>(this, "goals", PrimitiveType.json())
    val COUNTERS = Column<String?>(this, "counters", PrimitiveType.json())
    val PERMALINK_ID = Column<Long?>(this, "permalink_id", PrimitiveType.uint64())
    val PHONE_ID = Column<Long?>(this, "phone_id", PrimitiveType.uint64())
    val CALLTRACKING_SETTINGS_ID = Column<Long?>(this, "calltracking_settings_id", PrimitiveType.uint64())
    val TIME_TARGET = Column<String?>(this, "time_target", PrimitiveType.json())
    val STRATEGY = Column<String?>(this, "strategy", PrimitiveType.json())
    val RETARGETING_CONDITION = Column<String?>(this, "retargeting_condition", PrimitiveType.json())
    val VIDEOS_ARE_NON_SKIPPABLE = Column<Boolean?>(this, "videos_are_non_skippable", PrimitiveType.bool())
    val BRAND_SURVEY_ID = Column<String?>(this, "brand_survey_id", PrimitiveType.utf8())
    val BRIEF_SYNCED = Column<Boolean?>(this, "brief_synced", PrimitiveType.bool())
    val SHOWS_FREQUENCY_LIMIT = Column<String?>(this, "shows_frequency_limit", PrimitiveType.json())
    val STRATEGY_PLATFORM = Column<Int?>(this, "strategy_platform", PrimitiveType.uint32())
    val IS_ECOM = Column<Boolean?>(this, "is_ecom", PrimitiveType.bool())
    val CRR = Column<Int?>(this, "crr", PrimitiveType.uint32())
    val FEED_ID = Column<Long?>(this, "feed_id", PrimitiveType.uint64())
    val FEED_FILTERS = Column<String?>(this, "feed_filter", PrimitiveType.json())
    val CPM_ASSETS = Column<String?>(this, "cpm_assets", PrimitiveType.json())
    val CPM_CAMPAIGN_MEASURERS = Column<String?>(this, "cpm_campaign_measurers", PrimitiveType.json())
    val BRAND_SAFETY = Column<String?>(this, "brand_safety", PrimitiveType.json())
    val DISABLED_PLACES = Column<String?>(this, "disabled_places", PrimitiveType.json())
    val RELEVANCE_MATCH = Column<String?>(this, "relevance_match", PrimitiveType.json())

    val CAMPAIGN_ACCOUNT_INDEX = Index<CampaignTable>(this, ACCOUNT_ID, "account")
    private val COLUMNS: List<Column<*>> = listOf(
        ID,
        ADV_TYPE,
        NAME,
        STORE_URL,
        APP_ID,
        APP_TITLE,
        REGIONS,
        MINUS_REGIONS,
        TRACKING_URL,
        IMPRESSION_URL,
        TARGET_ID,
        CPA,
        WEEK_LIMIT,
        STATUS,
        TARGET_STATUS,
        CREATED_AT,
        UPDATED_AT,
        STARTED_AT,
        CONTENT_FLAGS,
        STATE_REASONS,
        OPTIONS,
        ACCOUNT_ID,
        SKAD_NETWORK_ENABLED,
        ADULT_CONTENT_ENABLED,
        HYPERGEO_ID,
        KEYWORDS,
        MINUS_KEYWORDS,
        SOCDEM,
        DEVICE_TYPES,
        GOALS,
        COUNTERS,
        PERMALINK_ID,
        PHONE_ID,
        CALLTRACKING_SETTINGS_ID,
        TIME_TARGET,
        STRATEGY,
        RETARGETING_CONDITION,
        VIDEOS_ARE_NON_SKIPPABLE,
        BRAND_SURVEY_ID,
        SHOWS_FREQUENCY_LIMIT,
        BRIEF_SYNCED,
        STRATEGY_PLATFORM,
        IS_ECOM,
        CRR,
        FEED_ID,
        FEED_FILTERS,
        CPM_ASSETS,
        CPM_CAMPAIGN_MEASURERS,
        BRAND_SAFETY,
        DISABLED_PLACES,
        RELEVANCE_MATCH,
    )

    override fun getInstance(realName: String, alias: String?): CampaignTable {
        return CampaignTable(realName, alias)
    }

    override fun getColumns(): List<Column<*>> = COLUMNS
    override fun getIndexes(): List<Index<*>> {
        return listOf(CAMPAIGN_ACCOUNT_INDEX)
    }
}
