package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class ContentTable(name: String = "content", alias: String? = null) : TableWithIndexes(name, alias) {
    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val OWNER_ID = Column<Long?>(this, "owner_id", PrimitiveType.uint64())
    val TYPE = Column<Int>(this, "type", PrimitiveType.uint32())
    val THUMB = Column<String>(this, "thumb", PrimitiveType.utf8())
    val SOURCE_URL = Column<String>(this, "source_url", PrimitiveType.utf8())
    val MDS_URL = Column<String?>(this, "mds_url", PrimitiveType.utf8())
    val META = Column<String>(this, "meta", PrimitiveType.json())
    val VIDEO_DURATION = Column<Int?>(this, "video_duration", PrimitiveType.uint32())
    val FILENAME = Column<String?>(this, "filename", PrimitiveType.utf8())
    val ACCOUNT_ID = Column<Long?>(this, "account_id", PrimitiveType.uint64())
    val DIRECT_IMAGE_HASH = Column<String?>(this, "direct_image_hash", PrimitiveType.utf8())

    val DIRECT_IMAGE_HASH_INDEX = Index(this, DIRECT_IMAGE_HASH, "direct_image_hash")
    val ACCOUNT_ID_INDEX = Index(this, ACCOUNT_ID, "account_index")

    private val COLUMNS = listOf(
        ID,
        OWNER_ID,
        TYPE,
        THUMB,
        SOURCE_URL,
        MDS_URL,
        META,
        VIDEO_DURATION,
        FILENAME,
        ACCOUNT_ID,
        DIRECT_IMAGE_HASH,
    )

    override fun getColumns() = COLUMNS
    override fun getIndexes() = listOf(DIRECT_IMAGE_HASH_INDEX, ACCOUNT_ID_INDEX)

    override fun getInstance(realName: String, alias: String?) = ContentTable(realName, alias)
}
