package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.Table
import ru.yandex.direct.ydb.table.TableWithIndexes

class DirectAdGroupTable(name: String = "direct_ad_group", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val DIRECT_CAMPAIGN_ID = Column<Long>(this, "direct_campaign_id", PrimitiveType.uint64())
    val DIRECT_AD_GROUP_ID = Column<Long>(this, "direct_ad_group_id", PrimitiveType.uint64())
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())

    private val COLUMNS: List<Column<*>> = listOf(
        ID,
        DIRECT_CAMPAIGN_ID,
        DIRECT_AD_GROUP_ID,
        STATUS,
    )

    val DIRECT_AD_GROUP_ID_INDEX = Index(this, DIRECT_AD_GROUP_ID, "direct_ad_group_id")
    val DIRECT_CAMPAIGN_ID_INDEX = Index(this, DIRECT_CAMPAIGN_ID, "direct_campaign")

    override fun getColumns() = COLUMNS

    override fun getIndexes() = listOf(DIRECT_AD_GROUP_ID_INDEX, DIRECT_CAMPAIGN_ID_INDEX)

    override fun getInstance(realName: String, alias: String?) = DirectAdGroupTable(realName, alias)
}
