package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.Table
import ru.yandex.direct.ydb.table.TableWithIndexes

class DirectAdTable(name: String = "direct_ad", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())
    val TITLE_CONTENT_ID = Column<Long?>(this, "title_content_id", PrimitiveType.uint64())
    val TEXT_CONTENT_ID = Column<Long?>(this, "text_content_id", PrimitiveType.uint64())
    val DIRECT_CONTENT_ID = Column<Long?>(this, "direct_content_id", PrimitiveType.uint64())
    val DIRECT_AD_GROUP_ID = Column<Long?>(this, "direct_ad_group_id", PrimitiveType.uint64())
    val DIRECT_AD_ID = Column<Long?>(this, "direct_ad_id", PrimitiveType.uint64())
    val DIRECT_IMAGE_CONTENT_ID = Column<Long?>(this, "direct_image_content_id", PrimitiveType.uint64())
    val DIRECT_VIDEO_CONTENT_ID = Column<Long?>(this, "direct_video_content_id", PrimitiveType.uint64())
    val DIRECT_HTML5_CONTENT_ID = Column<Long?>(this, "direct_html5_content_id", PrimitiveType.uint64())

    val DIRECT_AD_DIRECT_AD_GROUP_INDEX = Index(this, DIRECT_AD_GROUP_ID, "direct_ad_group")
    val DIRECT_AD_DIRECT_AD_ID_INDEX = Index(this, DIRECT_AD_ID, "direct_ad_id")
    val DIRECT_AD_CONTENT_INDEX = Index(this, DIRECT_CONTENT_ID, "direct_content_id")
    val DIRECT_AD_TITLE_CONTENT_INDEX = Index(this, TITLE_CONTENT_ID, "title_content_id")
    val DIRECT_AD_TEXT_CONTENT_INDEX = Index(this, TEXT_CONTENT_ID, "text_content_id")
    val DIRECT_AD_IMAGE_CONTENT_INDEX = Index(this, DIRECT_IMAGE_CONTENT_ID, "direct_image_content_id")
    val DIRECT_AD_VIDEO_CONTENT_INDEX = Index(this, DIRECT_VIDEO_CONTENT_ID, "direct_video_content_id")
    val DIRECT_AD_HTML5_CONTENT_INDEX = Index(this, DIRECT_HTML5_CONTENT_ID, "direct_html5_content_id")
    private val COLUMNS: List<Column<*>> = listOf(
        ID,
        STATUS,
        TITLE_CONTENT_ID,
        TEXT_CONTENT_ID,
        DIRECT_CONTENT_ID,
        DIRECT_AD_GROUP_ID,
        DIRECT_AD_ID,
        DIRECT_IMAGE_CONTENT_ID,
        DIRECT_VIDEO_CONTENT_ID,
        DIRECT_HTML5_CONTENT_ID,
    )

    override fun getColumns(): List<Column<*>> = COLUMNS
    override fun getIndexes() = listOf(
        DIRECT_AD_DIRECT_AD_GROUP_INDEX,
        DIRECT_AD_DIRECT_AD_ID_INDEX,
        DIRECT_AD_CONTENT_INDEX,
        DIRECT_AD_TITLE_CONTENT_INDEX,
        DIRECT_AD_TEXT_CONTENT_INDEX,
        DIRECT_AD_IMAGE_CONTENT_INDEX,
        DIRECT_AD_VIDEO_CONTENT_INDEX,
        DIRECT_AD_HTML5_CONTENT_INDEX,
    )

    override fun getInstance(realName: String, alias: String?): TableWithIndexes {
        return DirectAdTable(realName, alias)
    }
}
