package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Index
import ru.yandex.direct.ydb.table.TableWithIndexes

class DirectCampaignTable(name: String = "direct_campaign", alias: String? = null) : TableWithIndexes(name, alias) {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val DIRECT_CAMPAIGN_ID = Column<Long>(this, "direct_campaign_id", PrimitiveType.uint64())
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())
    val SYNCED_AT = Column<Long>(this, "synced_at", PrimitiveType.uint64())
    val REJECT_REASONS =
        Column<String?>(this, "reject_reasons", PrimitiveType.jsonDocument()) //todo нет вопроса, читается как емпти

    val DIRECT_CAMPAIGN_ID_INDEX = Index(this, DIRECT_CAMPAIGN_ID, "direct_campaign_id")

    private val COLUMNS = listOf(
        ID,
        DIRECT_CAMPAIGN_ID,
        STATUS,
        SYNCED_AT,
        REJECT_REASONS,
    )

    override fun getColumns() = COLUMNS

    override fun getIndexes() = listOf(
        DIRECT_CAMPAIGN_ID_INDEX
    )

    override fun getInstance(realName: String, alias: String?) =
        DirectCampaignTable(realName, alias)
}
