package ru.yandex.direct.core.entity.uac.repository.ydb.schema

import com.yandex.ydb.table.values.PrimitiveType
import ru.yandex.direct.ydb.column.Column
import ru.yandex.direct.ydb.table.Table

class DirectContentTable : Table("direct_content") {

    val ID = Column<Long>(this, "id", PrimitiveType.uint64()).pk()
    val STATUS = Column<Int>(this, "status", PrimitiveType.uint32())
    val TYPE = Column<Int>(this, "type", PrimitiveType.uint32())
    val DIRECT_IMAGE_HASH = Column<String?>(this, "direct_image_hash", PrimitiveType.utf8())
    val DIRECT_VIDEO_ID = Column<Long?>(this, "direct_video_id", PrimitiveType.uint64())
    val DIRECT_HTML5_ID = Column<Long?>(this, "direct_html5_id", PrimitiveType.uint64())

    private val COLUMNS: List<Column<*>> = listOf(
        ID,
        STATUS,
        TYPE,
        DIRECT_IMAGE_HASH,
        DIRECT_VIDEO_ID,
        DIRECT_HTML5_ID,
    )

    override fun getColumns(): List<Column<*>> = COLUMNS
}
